function y = force_with_yield_point(x, l_yield, k_stiffness)

% The program calculates the tension of a linear spring with a yield point

y = zeros( size(x, 1), size(x, 2) );

index_1 = abs(x) <= l_yield;
index_2 = ~index_1;

y(index_1) = k_stiffness * x(index_1); 
y(index_2) = k_stiffness * l_yield * sign(x(index_2));


end

